start_date         = datenum(1964,01,01); % initial date [days since 31.12.2BC]
end_date           = datenum(1965,01,01); % final date   [days since 31.12.2BC]
repeated_runs      = 1;                   % how often the same forcing period is repeated
timestep           = 1.0/24;              % timestep [days]
output_interval    = 24.0/24;             % output interval [days]
location.longitude = 20.0;                % longitude [deg], for zenith angle calculation
location.latitude  = 57.33;               % latitude  [deg], for zenith angle calculation
location.altitude  = 0.0;                 % altitude [m], for zenith angle calculation
density_water      = 1035.0;              % Density of water [kg/m3] to convert between mol/kg and mol/m3
num_vmove_steps    = 1;                   % if >1, this splits the vertical movement timestep (keep CFL criterion valid if tracers move very fast)
num_vdiff_steps    = 10;                  % if >1, this splits the vertical mixing (keep CFL criterion valid if tracers move very fast)
min_diffusivity    = 1e-4;                % minimum vertical turbulent diffusivity [m2/s]
max_diffusivity    = 1;                   % maximum vertical turbulent diffusivity [m2/s]
mylevels           = 20;                  % number of contour levels